/******************************/
/*                            */
/*   MazezaM main code        */
/*   Copyright 2004-2009 by   */
/*  Ventzislav Tzvetkov       */
/* http://hirudov.com         */
/*                            */
/* Compile with SDCC          */
/******************************/

/*
  This code may be used
  and distributed under
  the terms of the GNU
  General Public Licence.
*/

/* Version 1.1

-- 
To Do:
Make more colorfull and animated character by using sprites
*/

#include <coleco.h>

#include <string.h>

#define chrgen  0x0000
#define coltab  0x2000
#define chrtab  0x1800
#define sprtab  0x3800
#define sprgen  0x1b00

#define UP    1
#define RIGHT 2
#define DOWN  4
#define LEFT  8

/* From graphics.c */
extern byte PATTERNRLE[];
extern byte COLOR[];

/* From sounds.c */
extern byte ding_sound[];
extern byte noise_sound[];

/* Game variables */
int lives,w,h,i,j,l,t,r,rx,lx; /* Misc variables w - width, h - height*/
                                      /* i,j for loops and Player coordinates.*/
                                      /* t,r,rx,lx - for the Level build.*/

char *a[12],b[12][20],NumberString[]={'0','0',0x00}; /* Pointers to the Level.*/

const sound_t snd_table[] = {
	{ding_sound, SOUNDAREA1},
	{noise_sound, SOUNDAREA2}
};

static void noise (void)
{
play_sound (2);
}

void ding (void)
{
play_sound (1);
}

/* Non Maskable Interrupt */
void nmi(void)
{
 /* Play sounds */
// update_sound();
 /* Update sprites in VRAM with sprites[] */
/* update_sprites (32,sprgen); */
}

/* Init vdp game's screen */
static void init_vdp (void)
{
 /* temporary variable to be use in FOR functions */
 register byte i;

 /* temporary variables for the upload COLOR functions */
 int colpos;

 byte col;

 /* turn display off */
 screen_off ();
 /* disable NMI */
 disable_nmi ();
 /* clear VRAM */
 fill_vram (0,0,0x4000);

 /* Upload my tiles patterns */

 rle2vram (PATTERNRLE,chrgen);

 /* Upload tiles Color */

 colpos=coltab;

 for (i=0;i<32;++i)
 {
  col=COLOR[i];
  fill_vram (colpos,col,64);
  colpos +=64;
 }

 /* Fill Pattern and Color in VRAM */

 for (i=0;i<8;++i)
 {
  get_vram (chrgen+i*256,sprites,256);
  put_vram (chrgen+8*256+i*256,sprites,256);
  put_vram (chrgen+8*512+i*256,sprites,256);
  get_vram (coltab+i*256,sprites,256);
  put_vram (coltab+8*256+i*256,sprites,256);
  put_vram (coltab+8*512+i*256,sprites,256);
 }

 /* Clear sprites from screen */
 clear_sprites (0,64);
 /* Black screen border */
 vdp_out (7,0xf1);
 /* turn display on */
 screen_on ();
 /* enable NMI */
 enable_nmi ();
}

/* Clear Screen */
void clrscr(void)
{
 fill_vram (chrtab,0x20,0x300);
}

/* PRINT AT X,Y ON SCREEN */
void print_at (byte x, byte y,char *s)
{
 register unsigned i;
 disable_nmi ();
 i = strlen (s);
 put_vram (chrtab+y*32+x,s,i);
 enable_nmi ();
}

void Level(int mazenumber){
int k;
char *n; /* n contains pointer to the Level name string.*/
 screen_off();
 disable_nmi();
 clrscr();
 switch (mazenumber)
   { case 1: n="H O";w=7;h=2;
  lx=1;rx=1;a[1]=" `  `  ";
            a[2]=" p  qs ";break;

  case 2: n="E D I";w=8;h=3;
  lx=3;rx=2;a[1]="    ";a[2]="     ";
   a[3]=" x x x  ";break;

  case 3: n="U,  U  A";w=5;h=11;
   lx=11;rx=1;a[1]="  `  ";a[2]=" h ik";a[3]=" qs  ";
   a[4]="x x  ";a[5]="   ";a[6]="  ";a[7]="` `  ";
   a[8]=" h h ";a[9]=" p p ";a[10]="x y{ ";a[11]="    ";break;

   case 4:  n="T  F";w=13;h=6;lx=1;rx=1;
   a[1]="   abbbc     ";a[2]="x yzzz{  yz{ ";a[3]=" p qrs qrrs  ";
   a[4]="    ";a[5]=" ijk h   ik  ";a[6]="       ";
   break;

   case 5: n="L--L";w=14;h=4;lx=2;rx=4;
   a[1]="     ";a[2]="        ";
   a[3]="qs  p qs qrs  ";a[4]="   abbbbbbc  `";break;

   case 6: n="L\241\235  H\252\234\235\252"; w=5; h=4; lx=2; rx=1;
      a[1]=" x x ";
   a[2]="   ";
   a[3]="    ";
   a[4]=" qs p";
   break;

   case 7: n="S\245 E"; w=5; h=rx=3; lx=1;
   a[1]="  qs ";
   a[2]=" x   ";
   a[3]=" ` ac";
   break;

   case 8: n="B  P";w=7;h=6;lx=5;rx=3;
   a[1]="   p   ";a[2]=" ijjk  ";a[3]=" abc ac";
   a[4]="    ";a[5]="    ";a[6]="x y{   ";break;

   case 9: n="T  F D";
   w=16;h=7;lx=1;rx=7;a[1]="         ";
   a[2]="      ";a[3]="y{ y{ yzzzz{ x x";
   a[4]="qs     p p      ";a[5]="  ijjjjjjjjjjjk ";
   a[6]=" ` ac    ` abc  ";a[7]="  p   qrs     qs";break;

   case 10: n=", T";
   w=15;h=4;lx=3;rx=1;
   a[1]=" ijjk  ijjk  ik";a[2]=" p qs qs p qs  ";
   a[3]="      ";a[4]="       ";break;

   case 11:  n="D C";w=9;h=7;lx=7;rx=3;
   a[1]=" `  abbc ";a[2]=" h  h ik ";a[3]=" p qrrs p";
   a[4]="x y{  x  ";a[5]="     ";a[6]="   ";
   a[7]="  p      ";break;

   case 12: n="I O";w=14;h=10;lx=8;rx=1;
   a[1]="            ` ";a[2]=" ijjjjjjjjk  h";
   a[3]=" qrs       qs ";a[4]=" x yzzzzzz{ x ";
   a[5]="     ";a[6]="       ";
   a[7]=" ` abbbbbc ac ";a[8]=" h h h    ijk ";
   a[9]=" qrrrrrrrrrrs ";a[10]="              ";break;

   default:
   print_at(0,10,"CONGRATULATIONS!YOU'VE COMPLETEDTHE MAZEZAM. WELL DONE!");
   screen_on(); delay(400);
   return;
 }

 for (i=1;i<h+1;i++) strcpy(&b[i][0],a[i]);

l=((32-w)/2);t=((22-h)/2);r=32-l-w;print_at(0,0,"   ");
NumberString[0]='0'+mazenumber/10;NumberString[1]='0'+mazenumber%10;
print_at(10,0,NumberString);

print_at(14,0,"   ");

NumberString[0]='0'+lives/10;NumberString[1]='0'+lives%10;
print_at(26,0,NumberString);print_at(30,0,"");

for (i=1;i!=t+1;i++) print_at(0,i,"");

for (i=1;i!=h+1;i++){
if (i==lx) for (k=0;k!=l;k++) print_at(k,t+i," ");
if (i!=lx) for (k=0;k!=l;k++) print_at(k,t+i,"");
print_at(l,t+i,a[i]); /* Print the Level line.*/
if (i==rx) for (k=0;k!=r;k++) print_at(k+l+w,t+i," ");
if (i!=rx) for (k=0;k!=r;k++) print_at(k+l+w,t+i,"");
}

for (i=t+h+1;i!=23;i++) print_at(0,i,"");
j=strlen(n);
 {for (k=0;k!=((30-j)/2);k++) print_at(k,23,"");
   print_at(k++,23," ");print_at(k,23,n);
  for (k=0;k!=((30-j)/2);k++) print_at(31-k,23,"");
  print_at(31-k,23," ");
  }
screen_on();enable_nmi();
 for (i=0;i!=l;i++){print_at(i,t+lx,"*");delay(5);
 print_at( i,t+lx," ");}

 print_at(l-1,t+lx,"#*");
 i=lx;j=1;
}

const char MazezaMT[] = {0x64,0x6D,0x76,0x7F,0x86,0x8D,0x6C,0x00, /* MazezaM logo */
                   0x6C,0x75,0x7E,0x87,0x8E,0x6D,0x64,0x00, /* Color Table  */
                   0x74,0x7D,0x86,0x8F,0x6E,0x65,0x6C,0x00,
                   0x7C,0x85,0x8E,0x6F,0x66,0x6D,0x74,0x00,
                   0x84,0x8D,0x6E,0x67,0x6E,0x75,0x7C,0x00,
                   0x8C,0x6D,0x66,0x6F,0x76,0x7D,0x84,0x00,
                   0x6C,0x65,0x6E,0x77,0x7E,0x85,0x8C,0x00};

/* Main routine */
void main(void)
{

byte mazeno,ModeID,direction,rand=0;

 init_vdp();

for (;;) {
 clrscr(); print_at(0,0,"");print_at(14,0,"");print_at(30,0,"");

 for (ModeID=1;ModeID!=9;ModeID++)
 put_vram (chrtab+ModeID*32,"",32);
 
 for (ModeID=9;ModeID!=15;ModeID++)
 {print_at(0,ModeID,"");print_at(30,ModeID,"");}
 put_vram (chrtab+480,"",32);

 print_at(5,12,"COLECOVISION V %");
 print_at(5,13," V T");
 print_at(7,23,"://.\245");
 print_at(7,19,"PRESS FIRE TO START");
 /* Make Title Sound */
 ding();
 /* Print Title */
 print_at(12,10,MazezaMT);
 /* enable NMI */
// enable_nmi();
for (;;) {

 if (rand%22==0) {
 ModeID=(ModeID+1)*(ModeID<6);
print_at(12,10,&MazezaMT[ModeID*8]);
}
 delay(5);
  if ((joypad_1)&0xf0) break;
 }
 mazeno=1;lives=3;

 Level(mazeno);

for(;;) {
 direction=(joypad_1);
 rand++;
 if (!direction) continue;

if (direction&0xf0) {print_at(l+j-1,t+i,"&");lives--;
 switch (rand%10){

	case 0:print_at(l+j-3,t+i-1,"ARGH!");
		break;

	case 1:print_at(l+j-3,t+i-1,"OUCH!");
		break;

	case 2:print_at(l+j-3,t+i-1,"GRRR!");
		break;

	case 3:print_at(l+j-3,t+i-1,"NOOU!");
		break;

	case 4:print_at(l+j-3,t+i-1,"NAAH!");
		break;

	case 5:print_at(l+j-3,t+i-1,"UUUF!");
		break;

	case 6:print_at(l+j-3,t+i-1,"AAAH!");
		break;

	case 7:print_at(l+j-3,t+i-1,"OUUF!");
		break;

	case 8:print_at(l+j-3,t+i-1,"PAAF!");
		break;

	default: print_at(l+j-3,t+i-1,"UUUF!");
		break;


}


 noise();delay(120);
 if (lives) Level(mazeno); else {print_at(27,0,"0");
 print_at(10,10,"GAME OVER!"); delay(180);break;}}

 if ((direction==RIGHT) && (i==rx && j==w)) {print_at(l+j-1,t+i," ");
 for (i=l+w;i!=32;i++) {print_at(i,t+rx,"*");delay(5);print_at(i,t+rx," ");}
 print_at(31,t+rx,"*");rx--;
 switch (rand%6)

 {case 0: print_at(25,t+rx,"H!");break;
  case 1: print_at(25,t+rx,"H!");break;
  case 2: print_at(28,t+rx,"Y!");break;
  case 3: print_at(26,t+rx,"G!");break;
  case 4: print_at(24,t+rx,"Y-!");break;
  default: print_at(28,t+rx,"Y!");break;
 }
 ding();delay(80);
 lives++;Level(++mazeno); if (mazeno==13) break; direction=0;}

if ((direction==RIGHT) && j<w) if (b[i][j]==' '){
print_at(l+j-1,t+i," ");j++;
print_at(l+j-1,t+i,"*");} 

 else

if (b[i][w-1]==' ') {j++;
for (ModeID=w-1;ModeID>0;ModeID--) b[i][ModeID]=b[i][ModeID-1];
b[i][0]=' ';b[i][w]=0;
print_at(l,t+i,&b[i][0]);
print_at(l+j-1,t+i,"*");}

if ((direction==LEFT) && j>1) if (b[i][j-2]==' '){
print_at(l+j-1,t+i," ");j--;
print_at(l+j-1,t+i,"*");} else

if (b[i][0]==' ') {j--;
for (ModeID=1;ModeID!=w;ModeID++) b[i][ModeID-1]=b[i][ModeID];
b[i][w-1]=' ';
print_at(l,t+i,&b[i][0]);
print_at(l+j-1,t+i,"*");}

if ((direction==DOWN) && i<h) if (b[i+1][j-1]==' ') {
print_at(l+j-1,t+i," ");i++;
print_at(l+j-1,t+i,"*");}

if ((direction==UP  ) && i>1) if (b[i-1][j-1]==' ') {
print_at(l+j-1,t+i," ");i--;
print_at(l+j-1,t+i,"*");}

delay(6);
}
}
}
